%function [x_axis,y_axis,z_axis] = get_Vbias_vs_B
%% set the default font size for all figure
set(0,'defaultAxesFontSize',20)

%% ask the user to load the file
uiwait(msgbox('Choose the file you want to analyze'))
[fileName,pathName,~] = uigetfile('*.dat', 'Open file .dat');

%% get the data by reading the file
file = importdata(fullfile(pathName,fileName));

%% ask for the voltage bias amplification
prompt_Vbias = 'enter the dc Vbias module amplification in Volts';
dlgtitle_Vbias = 'Input';
user_val_Vbias = inputdlg(prompt_Vbias,dlgtitle_Vbias);
Vbias_val = str2num(user_val_Vbias{1});

%% ask for the input lockin amplification
prompt_Vac = 'enter input lockin amplification in Volts';
dlgtitle_Vac = 'Input';
user_val_Vac = inputdlg(prompt_Vac,dlgtitle_Vac);
Vac_val = str2num(user_val_Vac{1});

% %% ask for the factor to convert Bx to Btot
% prompt_Bx = 'enter the factor for converting Bx (T) to B (T)';
% dlgtitle_Bx = 'Input';
% user_val_Bx = inputdlg(prompt_Bx,dlgtitle_Bx);
% Bx_val = str2num(user_val_Bx{1});

%% ask for the measured voltage amplification
prompt_Vmeas = 'enter the amplification for measured voltage in Volts';
dlgtitle_Vmeas = 'Input';
user_val_Vmeas = inputdlg(prompt_Vmeas,dlgtitle_Vmeas);
Vmeas_val = str2num(user_val_Vmeas{1});

%% ask for the measured lockin current (lockinX) amplification
prompt_Imeas = 'enter the amplification for measured lockin current (lockinX) in Amps';
dlgtitle_Imeas = 'Input';
user_val_Imeas = inputdlg(prompt_Imeas,dlgtitle_Imeas);
Imeas_val = str2num(user_val_Imeas{1});

%% Reading the size of Vbias 
str_Vbias = char(file.textdata(6));
str_split = strsplit(str_Vbias);
size_Vbias = str2num(str_split{3});

%% Getting Vbias values
Vbias = file.data(1:size_Vbias,1)*Vbias_val;

%% Reading the size of Vg and getting the Vg values
str_Vg = char(file.textdata(12));
str_split = strsplit(str_Vg);
size_Vg = str2num(str_split{3});

%% Getting Vmeasure and Imeasure (lockinX) values
s=1;
Vmeasure = zeros(size_Vbias,size_Vg);
Imeasure = zeros(size_Vbias,size_Vg);
for i=1:size_Vg
    Vmeasure(1:size_Vbias,i)=file.data(s:s+size_Vbias-1,5)*Vmeas_val;
    Imeasure(1:size_Vbias,i)=file.data(s:s+size_Vbias-1,6)*Imeas_val;%lockinX value
    Vg(i) = file.data(s,2);% in mV
    s=s+size_Vbias;
end
dIdV = Imeasure/Vac_val;
% M = max(dIdV,[],2);
% for j=1:size_Vbias
%     dIdV_normalized(j,:)=dIdV(j,:)/M(j);
% end

figure;
% ec=1.60217663e-19;
% h=6.62607015e-34;
x_axis = Vg;
%y_axis = Vbias*1000;%in mV
y_axis = (Vmeasure(:,1)*1000)-Vmeasure((size_Vbias+1)/2,1)*1000;%in mV
%M = max(dIdV,[],'all');
%z_axis = dIdV/M;%./(2*ec^2/h);
z_axis = dIdV;
[X,Y] = meshgrid(x_axis,y_axis);
figure1 = pcolor(X,Y,z_axis);
hold on
set(figure1, 'EdgeColor', 'none');
cl=colorbar;
% caxis([2.1*10^-6 4*10^-6])
% cl.Ticks = [2.1*10^-6 2.12*10^-6 2.14*10^-6 2.16*10^-6 2.18*10^-6 2.2*10^-6];
cl.Label.String = 'G/G_{max}';
xlabel('$V_{g1}(mV)$','Interpreter','latex')
ylabel('$V_{bias}(mV)$','Interpreter','latex');

%end